/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ValoresComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComprobanteCompra
extends Comprobante {
    private static final long serialVersionUID = 2868564980183990343L;
    public static final String C_TIPO_SUSTENTO = "tipoSustento";
    public static final String C_TIPO_COMPROBANTE = "tipoComprobante";
    public static final String C_FECHA_REGISTRO = "fechaRegistro";
    @NotNull(message="Debe seleccionar el tipo de Identificaci\u00f3n del sustento tributario")
    private String tipoSustento;
    private String descripcionTipoSustento;
    @NotNull(message="Debe seleccionar el tipo de Comprobante")
    private String tipoComprobante;
    private String descripcionTipoComprobante;
    @NotNull(message="Debe escoger el valor Fecha Registro")
    private Date fechaRegistro = new Date();
    private ValoresComprobanteVenta valoresComprovanteVenta = new ValoresComprobanteVenta();

    public ComprobanteCompra() {
        this.valoresComprovanteVenta.setPropietario((ObjetoModelo)this);
    }

    @Override
    public void inicializar() {
        this.fechaRegistro = ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado().getTime();
        super.inicializar();
    }

    @Override
    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (!this.validarFechaRegistro(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (this.validarFechaEmision(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarPattern("\\d{3}(?<!000)", this.getEstablecimiento(), "El valor Establecimiento debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ", resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarPattern("\\d{3}(?<!000)", this.getPuntoEmision(), "El valor Punto de emisi\u00f3n debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ", resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarPattern("\\d{1,9}", this.getSecuencial(), "El valor Secuencial debe ser solo n\u00fameros.  M\u00ednimo 1 d\u00edgito, m\u00e1ximo 9. Diferente de cero. ", resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarPattern("\\d{3,49}", this.getNumAutorizacion(), "El valor No. autorizaci\u00f3n debe ser solo n\u00fameros.  M\u00ednimo 3 d\u00edgitos, m\u00e1ximo 49. Diferente de cero. ", resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarSecuencial(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarNumAutorizacion(resultado).esEstadoFallido()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    @Override
    public ComprobanteCompra crearCopiaEdicion() {
        ComprobanteCompra copia = new ComprobanteCompra();
        copia.setEstablecimiento(super.getEstablecimiento());
        copia.setPuntoEmision(super.getPuntoEmision());
        copia.setSecuencial(super.getSecuencial());
        copia.setNumAutorizacion(super.getNumAutorizacion());
        copia.setFechaEmision(super.getFechaEmision());
        copia.setObligatorio(super.isObligatorio());
        copia.setTipoSustento(this.tipoSustento);
        copia.setDescripcionTipoSustento(this.descripcionTipoSustento);
        copia.setTipoComprobante(this.tipoComprobante);
        copia.setDescripcionTipoComprobante(this.descripcionTipoComprobante);
        copia.setFechaRegistro(this.fechaRegistro);
        copia.setPropietario(this.propietario);
        copia.valoresComprovanteVenta = this.valoresComprovanteVenta.crearCopiaEdicion();
        copia.getValoresComprovanteVenta().setPropietario((ObjetoModelo)copia);
        return copia;
    }

    @Override
    public void actualizarInformacion(Comprobante copiaEdicion) {
        ComprobanteCompra comprobanteCompra = (ComprobanteCompra)copiaEdicion;
        this.setTipoSustento(comprobanteCompra.getTipoSustento());
        this.setDescripcionTipoSustento(comprobanteCompra.getDescripcionTipoSustento());
        this.setTipoComprobante(comprobanteCompra.getTipoComprobante());
        this.setDescripcionTipoComprobante(comprobanteCompra.getDescripcionTipoComprobante());
        this.setFechaRegistro(comprobanteCompra.getFechaRegistro());
        super.actualizarInformacion(copiaEdicion);
    }

    private ResultadoValidacion validarFechaRegistro(ResultadoValidacion resultado) {
        if (!((Iva)this.getRaizModelo()).getDatosDeclaracion().isEsMicroEmpresa() && !Util.isFechasIgualesMesAnio(this.getFechaRegistro(), ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "registro", "igual"));
        }
        return resultado;
    }

    @Override
    protected ResultadoValidacion validarFechaEmision(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        boolean esMicroEmpresa = iva.getDatosDeclaracion().isEsMicroEmpresa();
        Calendar fechaPeriodo = iva.getFechaPeriodoDeclarado();
        if (esMicroEmpresa) {
            if (!Util.isFechaMenorIgual(this.getFechaEmision(), this.getFechaRegistro()) || !Util.isFechaMenorIgualPeriodoMesAnio(this.getFechaEmision(), fechaPeriodo)) {
                return resultado.fallarValidacion("La fecha de emisi\u00f3n debe ser menor o igual a la fecha de Registro y al periodo informado para microempresas");
            }
        } else if (!Util.isFechaMenorIgual(this.getFechaEmision(), this.getFechaRegistro())) {
            return resultado.fallarValidacion("La fecha de emisi\u00f3n debe ser menor o igual a la fecha de Registro");
        }
        if (!Util.isFechaMenorUnAnio(this.getFechaEmision(), this.getFechaRegistro())) {
            return resultado.fallarValidacion("La fecha de emisi\u00f3n no debe ser menor con mas de un a\u00f1o a la fecha de registro");
        }
        return resultado;
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("establecimiento");
        Element eValor = (Element)valorList.item(0);
        this.setEstablecimiento(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("puntoEmision");
        eValor = (Element)valorList.item(0);
        this.setPuntoEmision(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("secuencial");
        eValor = (Element)valorList.item(0);
        this.setSecuencial(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("autorizacion");
        eValor = (Element)valorList.item(0);
        this.setNumAutorizacion(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("fechaEmision");
        eValor = (Element)valorList.item(0);
        this.setFechaEmision(Util.importarFecha(eValor));
        this.setObligatorio(true);
        valorList = elemento.getElementsByTagName("codSustento");
        eValor = (Element)valorList.item(0);
        this.tipoSustento = eValor.getTextContent().trim();
        this.descripcionTipoSustento = String.valueOf(this.getTipoSustento()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionSustento(this.getTipoSustento());
        valorList = elemento.getElementsByTagName(C_TIPO_COMPROBANTE);
        eValor = (Element)valorList.item(0);
        this.tipoComprobante = eValor.getTextContent().trim();
        this.descripcionTipoComprobante = String.valueOf(this.getTipoComprobante()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionComprobante(this.getTipoComprobante());
        valorList = elemento.getElementsByTagName(C_FECHA_REGISTRO);
        eValor = (Element)valorList.item(0);
        this.fechaRegistro = Util.importarFecha(eValor);
        this.getValoresComprovanteVenta().importar(elemento, null);
        return this;
    }

    public String getTipoSustento() {
        return this.tipoSustento;
    }

    public String getDescripcionTipoSustento() {
        return this.descripcionTipoSustento;
    }

    public String getTipoComprobante() {
        return this.tipoComprobante;
    }

    public String getDescripcionTipoComprobante() {
        return this.descripcionTipoComprobante;
    }

    public Date getFechaRegistro() {
        return this.fechaRegistro;
    }

    public ValoresComprobanteVenta getValoresComprovanteVenta() {
        return this.valoresComprovanteVenta;
    }

    public String getSerial() {
        return String.valueOf(this.getEstablecimiento()) + "-" + this.getPuntoEmision() + "-" + this.getSecuencial();
    }

    public void setTipoSustento(String tipoSustento) {
        String oldValue = this.tipoSustento;
        this.tipoSustento = StringUtil.isNullOrEmpty((String)tipoSustento) ? tipoSustento : tipoSustento.toUpperCase();
        this.firePropertyChange(C_TIPO_SUSTENTO, oldValue, this.tipoSustento);
    }

    public void setDescripcionTipoSustento(String descripcionTipoSustento) {
        this.descripcionTipoSustento = descripcionTipoSustento;
    }

    public void setTipoComprobante(String tipoComprobante) {
        String oldValue = this.tipoComprobante;
        this.tipoComprobante = StringUtil.isNullOrEmpty((String)tipoComprobante) ? tipoComprobante : tipoComprobante.toUpperCase();
        this.firePropertyChange(C_TIPO_COMPROBANTE, oldValue, this.tipoComprobante);
    }

    public void setDescripcionTipoComprobante(String descripcionTipoComprobante) {
        this.descripcionTipoComprobante = descripcionTipoComprobante;
    }

    public void setFechaRegistro(Date fechaRegistro) {
        Date oldValue = this.fechaRegistro;
        this.fechaRegistro = fechaRegistro;
        this.firePropertyChange(C_FECHA_REGISTRO, oldValue, this.fechaRegistro);
    }

    public void setValoresComprovanteVenta(ValoresComprobanteVenta valoresComprovanteVenta) {
        this.valoresComprovanteVenta = valoresComprovanteVenta;
    }
}

